/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLogQuery;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminElementTableModel;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminLogElementTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import java.util.Vector;

public class VWAdminElementInLogTableModel
extends VWAdminElementTableModel {
    protected VWLog m_vwLog = null;
    protected VWLogElement m_curLogElement = null;
    protected VWLogQuery m_vwLogQuery = null;
    protected String m_logName = null;

    public VWAdminElementInLogTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) throws Exception {
        super(resultsPane, event);
        this.m_logName = event.getSelectedItem();
        if (this.m_vwSession == null) {
            return;
        }
        if (event.getExecuteSearchFlag()) {
            this.initTable();
        }
    }

    protected void startTheQuery() throws Exception {
        this.m_vwLog = this.m_vwSession.fetchEventLog(this.m_logName);
        this.m_vwLog.setBufferSize(this.m_maxReturned);
        this.m_vwLogQuery = this.m_vwLog.startQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars);
        this.getExposedFieldsDefinition();
    }

    protected int fetchQueryCount() throws Exception {
        int count = -1;
        try {
            this.m_vwLog = this.m_vwSession.fetchEventLog(this.m_logName);
            this.m_vwLog.setBufferSize(this.m_maxReturned);
            this.m_vwLogQuery = this.m_vwLog.startQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars);
            count = this.m_vwLogQuery.fetchCount();
        }
        catch (Exception ex) {
            count = -1;
            throw ex;
        }
        return count;
    }

    protected void retrieveElements() throws Exception {
        VWLogElement curElement = null;
        int rowNum = 0;
        try {
            this.m_objectCache.removeAllElements();
            for (rowNum = 0; rowNum < this.m_maxReturned && (curElement = this.m_vwLogQuery.next()) != null; ++rowNum) {
                VWAdminLogElementTableData dataField = new VWAdminLogElementTableData(curElement, this.m_logonUser, rowNum + 1, rowNum);
                this.m_objectCache.addElement(dataField);
            }
            if (rowNum > 0) {
                ++this.m_setNum;
            }
            if (this.m_vwLogQuery.hasNext()) {
                this.setHasNext(true);
            } else {
                this.setHasNext(false);
            }
        }
        catch (OutOfMemoryError err) {
            throw new VWException("vw.toolkit.admin.result.outOfMemoryError", "Out of memory.  Please use a smaller maximum returned set.");
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected void buildAvailableColumnsList() {
        VWDataField[] vwDataFields = null;
        VWLogElement curElement = null;
        try {
            this.m_availableColumns.removeAllElements();
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminLogElementTableData woData = (VWAdminLogElementTableData)this.m_objectCache.elementAt(i);
                curElement = (VWLogElement)woData.getElement();
                vwDataFields = curElement.getDataFields();
                for (int j = 0; j < vwDataFields.length; ++j) {
                    if (this.isInVector(vwDataFields[j].getName(), this.m_availableColumns)) continue;
                    this.m_availableColumns.addElement(vwDataFields[j].getName());
                    this.m_availableFields.addElement(vwDataFields[j]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getObjectAt(int rowIndex) {
        VWAdminLogElementTableData obj = null;
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        obj = (VWAdminLogElementTableData)this.m_objectCache.elementAt(rowIndex);
        return obj;
    }

    protected void buildObjectCache() {
    }

    protected void retrieveRowData() {
        this.retrieveRowDataForLogElement();
    }

    protected void retrieveRowData(int rowIndex) {
        this.retrieveRowDataForLogElement(rowIndex);
    }

    protected void getExposedFieldsDefinition() throws Exception {
        VWLogDefinition vwLogDefinition = null;
        vwLogDefinition = this.m_vwLog.fetchLogDefinition();
        this.m_vwFieldDefinitions = vwLogDefinition == null ? null : vwLogDefinition.getFields();
    }

    protected Object getFieldValue(VWLogElement obj, String colName) {
        try {
            if (obj.hasField(colName)) {
                return obj.getFieldValue(colName);
            }
            return VWResource.s_emptyString;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return VWResource.s_emptyString;
        }
    }

    private void retrieveRowDataForLogElement() {
        VWLogElement curElement = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminLogElementTableData woData = (VWAdminLogElementTableData)this.m_objectCache.elementAt(i);
                curElement = (VWLogElement)woData.getElement();
                rowData = new Vector<Object>();
                rowData.addElement(new Integer(woData.getDisplayRowIndex()));
                for (int col = 1; col < this.m_headers.size(); ++col) {
                    dataField = null;
                    fieldName = (String)this.m_headers.elementAt(col);
                    vwDataField = this.findDataFieldInElement(curElement, fieldName);
                    dataField = vwDataField != null ? new VWAdminFieldsTableData(vwDataField, curElement, this.m_vwSession, 2) : null;
                    rowData.addElement(dataField);
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void retrieveRowDataForLogElement(int rowIndex) {
        VWLogElement curElement = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            VWAdminLogElementTableData woData = (VWAdminLogElementTableData)this.m_objectCache.elementAt(rowIndex);
            curElement = (VWLogElement)woData.getElement();
            rowData = new Vector<Object>();
            rowData.addElement(new Integer(woData.getDisplayRowIndex()));
            for (int col = 1; col < this.m_headers.size(); ++col) {
                dataField = null;
                fieldName = (String)this.m_headers.elementAt(col);
                vwDataField = this.findDataFieldInElement(curElement, fieldName);
                dataField = vwDataField != null ? new VWAdminFieldsTableData(vwDataField, curElement, this.m_vwSession, 2) : null;
                rowData.addElement(dataField);
            }
            this.m_rowCache.setElementAt(rowData, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

